/** @file   civiliancontroller.h
 * @brief   Declaraction of CivilianController - class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:41 $
 * @author  Tomi Lamminsaari
 */
 
#ifndef H_WWW_CIVILIANCONTROLLER_H
#define H_WWW_CIVILIANCONTROLLER_H

#include "waypointcontroller.h"

namespace WeWantWar {


/** @class  CivilianController
 * @brief   This controller controls the civilians walking in the playfield.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 *
 */
class CivilianController : public WaypointController
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================


  ///
  /// Constructors, destructor and operators
  /// ======================================

	/** Constructor.
   * @param     pObj              Pointer to GameObject we're controlling.
   */
	CivilianController( GameObject* pObj );


	/** Destructor
   */
	virtual ~CivilianController();

private:

	/** Copy constructor.
   * @param     rO                Reference to another CivilianController
   */
  CivilianController( const CivilianController& rO );

	/** Assignment operator
   * @param     rO                Reference to another CivilianController
   * @return    Reference to us.
   */
  CivilianController& operator = ( const CivilianController& rO );

public:


  ///
  /// Methods
  /// =======

  /** Updates this controller. Makes the object to follow the Route.
   */
  virtual void update();
  

  ///
  /// Getter methods
  /// ==============


protected:

  ///
  /// Members
  /// =======



private:

  ///
  /// Private members
  /// ===============

};

};  // end of namespace

#endif

/**
 * Version history
 * ===============
 * $Log: civiliancontroller.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:41  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:16:52+02  lamminsa
 * Initial revision
 *
 */
 
